/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.impl.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.Objects;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.tipsmod.api.TipsAPI;
import net.darkhax.tipsmod.api.resources.ITip;
import net.darkhax.tipsmod.impl.client.RenderUtils;
import net.darkhax.tipsmod.impl.gui.ListEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class ListEntryTip
extends ListEntry {
    final ITip tip;

    ListEntryTip(Minecraft mc, ITip tip) {
        super(mc);
        this.tip = tip;
    }

    public void m_6311_(PoseStack matrix, int index, int yStart, int xStart, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        if (!TipsAPI.canDisplayTip(this.tip)) {
            ListEntryTip.drawGradient(matrix, xStart - 2, yStart + 2, width + 2, height - 6, 0x40FF0000, -9437184, -10485760);
        }
        this.mc.f_91062_.m_92889_(matrix, this.tip.getTitle(), (float)xStart, (float)(yStart + 2), 0xFFFFFF);
        Font font = this.mc.f_91062_;
        Objects.requireNonNull(font);
        Objects.requireNonNull(font);
        RenderUtils.renderLinesWrapped(matrix, font, xStart, yStart + 7 + 9, 9, 0xFFFFFF, (FormattedText)this.tip.getText(), width);
    }

    @Override
    public void renderMouseOver(PoseStack matrix, int mouseX, int mouseY) {
        ArrayList<Object> tooltip = new ArrayList<Object>();
        tooltip.add(new TranslatableComponent("gui.tips.list.entry.tip_id", new Object[]{this.tip.getId().toString()}));
        tooltip.add(new TranslatableComponent("gui.tips.list.entry.added_by", new Object[]{Services.PLATFORM.getModName(this.tip.getId().m_135827_())}).m_130940_(ChatFormatting.BLUE));
        if (!TipsAPI.canDisplayTip(this.tip)) {
            tooltip.add(new TranslatableComponent("gui.tips.list.entry.disabled").m_130940_(ChatFormatting.RED));
        }
        tooltip.add(new TranslatableComponent("gui.tips.list.entry.cycle_time", new Object[]{ListEntryTip.ticksToTime(this.tip.getCycleTime() / 50, false, false)}));
        if (this.isSelected) {
            tooltip.add(new TranslatableComponent("gui.tips.list.entry.copied").m_130940_(ChatFormatting.GREEN));
        } else {
            tooltip.add(new TranslatableComponent("gui.tips.list.entry.click_to_copy").m_130940_(ChatFormatting.GRAY));
        }
        this.mc.f_91080_.m_96597_(matrix, tooltip, mouseX, mouseY);
    }

    @Override
    public void updateNarrator(NarrationElementOutput narrator) {
        narrator.m_169146_(NarratedElementType.TITLE, this.tip.getTitle());
        narrator.m_169146_(NarratedElementType.HINT, this.tip.getText());
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isSelected && this.m_5953_(mouseX, mouseY)) {
            this.mc.f_91068_.m_90911_(this.tip.getId().toString());
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public static void drawGradient(PoseStack mStack, int x, int y, int width, int height, int backgroundColor, int borderColorStart, int borderColorEnd) {
        RenderSystem.m_69465_();
        boolean zLevel = false;
        mStack.m_85836_();
        Matrix4f mat = mStack.m_85850_().m_85861_();
        ListEntryTip.drawGradientRect(mat, 0, x - 3, y - 4, x + width + 3, y - 3, backgroundColor, backgroundColor);
        ListEntryTip.drawGradientRect(mat, 0, x - 3, y + height + 3, x + width + 3, y + height + 4, backgroundColor, backgroundColor);
        ListEntryTip.drawGradientRect(mat, 0, x - 3, y - 3, x + width + 3, y + height + 3, backgroundColor, backgroundColor);
        ListEntryTip.drawGradientRect(mat, 0, x - 4, y - 3, x - 3, y + height + 3, backgroundColor, backgroundColor);
        ListEntryTip.drawGradientRect(mat, 0, x + width + 3, y - 3, x + width + 4, y + height + 3, backgroundColor, backgroundColor);
        ListEntryTip.drawGradientRect(mat, 0, x - 3, y - 3 + 1, x - 3 + 1, y + height + 3 - 1, borderColorStart, borderColorEnd);
        ListEntryTip.drawGradientRect(mat, 0, x + width + 2, y - 3 + 1, x + width + 3, y + height + 3 - 1, borderColorStart, borderColorEnd);
        ListEntryTip.drawGradientRect(mat, 0, x - 3, y - 3, x + width + 3, y - 3 + 1, borderColorStart, borderColorStart);
        ListEntryTip.drawGradientRect(mat, 0, x - 3, y + height + 2, x + width + 3, y + height + 3, borderColorEnd, borderColorEnd);
        mStack.m_85849_();
        RenderSystem.m_69482_();
    }

    private static void drawGradientRect(Matrix4f mat, int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        ListEntryTip.drawGradientRect(mat, zLevel, left, top, right, bottom, startAlpha, startRed, startGreen, startBlue, endAlpha, endRed, endGreen, endBlue);
    }

    private static void drawGradientRect(Matrix4f mat, int zLevel, int left, int top, int right, int bottom, float startAlpha, float startRed, float startGreen, float startBlue, float endAlpha, float endRed, float endGreen, float endBlue) {
        RenderSystem.m_69482_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_85982_(mat, (float)right, (float)top, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        buffer.m_85982_(mat, (float)left, (float)top, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        buffer.m_85982_(mat, (float)left, (float)bottom, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        buffer.m_85982_(mat, (float)right, (float)bottom, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    private static Component ticksToTime(int ticks, boolean prefix, boolean color) {
        String result;
        boolean isPositive = ticks > 0;
        ticks = Math.abs(ticks);
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        String string = result = (seconds %= 60) < 10 ? minutes + ":0" + seconds : minutes + ":" + seconds;
        TextComponent component = new TextComponent(prefix ? (isPositive ? "+" : "-") + result : result);
        return color ? (isPositive ? component.m_130940_(ChatFormatting.GREEN) : component.m_130940_(ChatFormatting.RED)) : component;
    }
}

